(ns identity-middleware.direct-access-filter
  (:require [wms-customer-info.core :as wms]
            [mdm-translation.core :as mdm-translate]))

(defn- error-check
  [response]
  (if (and (instance? clojure.lang.IFn response) (contains? response :error))
    nil
    response))

(defn- has-direct-access?
  [request]
  (contains? (:headers request) "direct-access-id"))

(defn- get-user-by-direct-access
  [request]
  (if-let [mdm-id (error-check (mdm-translate/direct-access->mdm (get (:headers request) "direct-access-id")))]
    (wms/wms-direct-access mdm-id request)))

(defn- direct-access-request
  [request]
  (and (has-direct-access? request) (get-user-by-direct-access request)))

;(defn direct-access-filter
;  [request]
;  (if-let [user (direct-access-request request)]
;    (process-successful-request request user "Filtered user by Direct Access Header.")
;    request))