(ns cacheing.core
  (:require [taoensso.carmine :as car  :refer (wcar)]
            [environ.core :refer [env]]
            [pcf-utils.core :as pcf]))

(def redis-uri
  (let [redis (:credentials (first (:p-redis (pcf/bound-services))))]
    (str "redis://:" (:password redis) "@" (:host redis) ":" (:port redis))))

(def ^:private redis-conn
  {:pool {}
   :spec {:uri redis-uri}})

(def ^:private cache-enabled
  (let [cache (or (env :cache-enabled) "false")]
    (not= "false" cache)))

(defn get-cache
  "Gets cache for customer/policy from redis."
  [key]
  (when cache-enabled
    (car/wcar redis-conn (car/get key))))

(defn set-cache
  "Sets cache in redis for customer/policy."
  ([key data]
   (when cache-enabled
     (car/wcar redis-conn (car/setex key 1200 data))))
  ([key data expiry]
   (when cache-enabled
     (car/wcar redis-conn (car/setex key expiry data)))))

(defn incr-key
  "Increments int for user"
  [key]
  (when cache-enabled
    (car/wcar redis-conn (car/incr key))))