(ns pcf-utils.core
  (:require [clojure.data.json :as json]))

(defn vcap [] (System/getenv "VCAP_APPLICATION"))

(def app-name
  (try
    (let [json (json/read-str (vcap) :key-fn keyword)]
      (or (:name json) "no-app-name"))
    (catch Exception e "no-vcap-app-name")))

(def app-id
  (try
    (let [json (json/read-str (vcap) :key-fn keyword)]
      (or (:application_id json) "no-app-id"))
    (catch Exception e "no-vcap-app-index")))