(ns claims.core
  (:require [soa.core :as soa]
            [clojure.tools.logging :as log]
            [clostache.parser :as template]
            [constants.core :as constants]))

(def ^:private template "templates/RetrieveClaimSummaries.xml")

(def ^:private url constants/claims-url)

(defn- model-mapper
  [policy model]
  {:policyNumber (:number policy) :claims (map :claim (:claims (:retrieveClaimSummariesResponse model)))})

(defn claims-model
  "Returns a claims model for the requested customer.
  **See** [Data Keys page for :claims](/data-keys#claims)"
  [customer]
  (soa/model customer url template model-mapper))
