(ns discounts.core
  (:require [soa.core :as soa]
            [constants.core :as constants]))

(defn- home-discounts-getter
  [policy summary]
  (first (:discounts (:policySummary (:retrievePropertyPolicyDetailResponse summary)))))

(defn- auto-discounts-getter
  [policy summary]
  (first (:discounts (:policySummary (:autoPolicySummary (:retrieveAutoPolicyDetailResponse summary))))))

(defn discounts-model
  "Returns a discounts model for the requested customer.
  **See** [Data-keys page for :discounts](/data-keys#discounts)"
  [customer]
  (soa/model customer constants/auto-policy-url "templates/RetrieveAutoPolicyDetails.xml" auto-discounts-getter
             constants/property-policy-url "templates/RetrievePropertyPolicyDetails.xml" home-discounts-getter))










