(ns {{name}}.services.rabbit-service
  (:require [langohr.core :as rmq]
            [langohr.channel :as lch]
            [langohr.queue :as lq]
            [langohr.basic :as lb]
            [{{name}}.utils.logger :as logger]))

(def ^{:const true} default-exchange-name "")

(defn connection-settings []
  {:username (System/getenv "AMQPUSER")
   :password (System/getenv "AMQPPASS")
   :vhost "/"
   :host (System/getenv "AMQPHOST")
   :port 5672})

(defn publish
  [message queue-name]
  (try
    (let [conn (rmq/connect (connection-settings))
          ch (lch/open conn)]
      (lq/declare ch queue-name {:auto-delete false :durable true :exclusive false})
      (lb/publish ch default-exchange-name queue-name message)
      (Thread/sleep 100)
      (rmq/close ch)
      (rmq/close conn))
    (catch Throwable th (logger/debug th))))
