(ns {{name}}.mysql-service
  (:import com.mchange.v2.c3p0.ComboPooledDataSource)
  (:require [clojure.java.jdbc :as sql]))

(defn connection-config []  {:classname "com.mysql.jdbc.Driver"
              :subprotocol "mysql"
              :subname (str "//" (System/getenv "DBRRHOST") ":3306/clientsuccess")
              :user (System/getenv "DBRRUSER")
              :password (System/getenv "DBRRPASS")})

(defn pool [connection-info]
  {:datasource (doto
                 (ComboPooledDataSource.)
                   (.setDriverClass (:classname connection-info))
                   (.setJdbcUrl (str "jdbc:" (:subprotocol connection-info) ":" (:subname connection-info)))
                   (.setUser (:user connection-info))
                   (.setPassword (:password connection-info))
                   ;; expire excess connections after 30 minutes of inactivity:
                   (.setMaxIdleTimeExcessConnections (* 30 60))
                   ;; expire connections after 3 hours of inactivity:
                   (.setMaxIdleTime (* 3 60 60)))})

(def pooled-db (delay (pool (connection-config))))

(defn conn [] @pooled-db)

(defn run-query [query params] (sql/query (conn) (into [query] params)))
