(ns scraper.fetch
  (:use [net.cgrand.enlive-html]
        [clojure.tools.logging])
  (:import [java.net URL]
           [java.util.concurrent BlockingQueue LinkedBlockingQueue TimeUnit]))

(def queue (LinkedBlockingQueue.))

(defn enqueue [url parse-fn callback]
  (let [desc {:url url :parse-fn parse-fn :callback callback}]
    (.put ^BlockingQueue queue desc)))

(defn fetch [url]
  (-> url URL. html-resource))

(defn process [desc]
  (try
    (let [{:keys [url parse-fn callback]} desc
          page (fetch url)]
      (let [res (parse-fn page)]
        (callback res)))
    (catch Exception e
      (error e e))))

(def running true)

(defn poller []
  (loop []
    (when running
      (when-let [desc (.poll ^BlockingQueue queue 1 TimeUnit/SECONDS)]
        (info "poller " (:url desc))
        (process desc))
      (recur))))

(defn stop []
  (alter-var-root #'running not))

(defn queue-empty? []
  (nil? (.peek ^BlockingQueue queue)))
