(ns scraper.core
  (:use [net.cgrand.enlive-html]
        [clojure.tools.logging])
  (:require [scraper.fetch :as fetch]
            [clojure.java.io :as io]))

(set! *warn-on-reflection* true)

; scraper
; queue of scrape maps:
; {:url-to-scrape :parse-function-for-url-type :callback-fn-for-result}

(defn scrape [url parse-fn callback]
  (fetch/enqueue url parse-fn callback))

(defn -main [& args]
  (future (fetch/poller)))

(defn stop []
  (fetch/stop))

(defn trim [s]
  (if s (clojure.string/trim s) ""))

(defn str-content [node]
  (remove empty?
          (flatten 
            (map (fn [el] 
                   (cond 
                     (string? el) (trim el)
                     (map? el) (str-content (:content el))))
                 node))))

(defn interpret [date time]
  (str date " " time))

(defn parse-fn [page]
  (let [date (-> page (select [:div.column-info :p]) first :content second trim)
        time (-> page (select [:div.column-info :p]) second :content second trim)
        datetime (interpret date time)
        where (-> page (select [:div.column-contact :address]) first :content str-content )
        txt (->>
              (-> page
                (select [:div.center-content :div :p ]))
              emit*
              (apply str))
        lat (-> page
              (select [[:meta (attr= :property "og:latitude")]]) first :attrs :content)
        lon (-> page
              (select [[:meta (attr= :property "og:longitude")]]) first :attrs :content)]
    [datetime where txt [lat lon]]))

(defn callback [res]
  (info "callback res " res)
  res)

#_(scrape "http://www.au.timeout.com/melbourne/music/events/9017/tumbleweed"
        parse-fn
        callback)

