(ns scraper.fetch
  (:use [net.cgrand.enlive-html]
        [clojure.tools.logging])
  (:import [java.net URL]
           [java.util.concurrent BlockingQueue LinkedBlockingQueue TimeUnit]))

(def queue (LinkedBlockingQueue.))

(defn enqueue [url parse-fn callback]
  (let [desc {:url url :parse-fn parse-fn :callback callback}]
    (.put ^BlockingQueue queue desc)))

(defn fetch [url]
  (-> url URL. html-resource))

(defn process [desc]
  (try
    (let [{:keys [url parse-fn callback]} desc
          page (fetch url)]
      (let [res (parse-fn page)]
        (callback res)))
    (catch Exception e
      (error e e))))

(defn poller []
  (loop []
    (let [desc (.take ^BlockingQueue queue)]
      (info "poller " (:url desc))
      (process desc)
      (recur))))
