(ns rss.read
  (:use [clojure.tools.logging])
  (:require [clj-http.client :as client]
            [clojure.data.xml :as xml]))

(defn item-field [item field]
  (->> item :content (filter #(= (:tag %) field)) first :content first ))

(defn parse-meta [item]
  (let [{:keys [tag attrs content]} item]
    [tag (first content) attrs]
  ))

(defn get-metadata [data]
  (->> data
    :content
    first
    :content
    (filter #(not= (:tag %) :item))
    (map parse-meta)))

(defn parse-item [item]
  (let [title (item-field item :title)
        title (second (.split title " - "))
        cat (item-field item :category)
        cat (.split cat " ")
        type (last cat)
        cat (apply str (butlast cat))
        desc (item-field item :description)
        guid (item-field item :guid)
        enclosure (->> item :content (filter #(= (:tag %) :enclosure)) first :attrs :url )
        pub-date (item-field item :pubDate)]
    {:title title :cat cat :type type :desc desc :guid guid :enclosure enclosure :pub-date pub-date}
    ))

(defn get-items [data]
  (->> data
    :content
    first
    :content
    (filter #(= (:tag %) :item))
    (map parse-item)))

(defn parse-body [body]
  (let [data (xml/parse-str body)
        metadata (get-metadata data)
        items (get-items data)]
    (info "parse-body items " (count items))
    {:metadata metadata :items items}))

(defn read-feed [url]
  (info "read-feed url " url)
  (let [res (client/get url)
        body (:body res)]
    (info "read-feed body " (count body))
    (assoc (parse-body body) :xml-str body)))

;(defn new-item? [item]
;  ; TODO
;  true)
;
;(defn add-item [item feed-id]
;  ; TODO)
;
;(defn read-feeds 
;  "grab all the feeds from the database, read each one and store the items"
;  []
;  (let [feeds (->> (all-feeds)
;                (map (juxt :_id :url)))]
;    (for [feed feeds]
;      (let [res (apply read-feed feed)
;            {:keys [feed-id xml-str metadata items]} res]
;        (save (new-stream  feed-id xml-str metadata))
;        (doseq [item items]
;          (if (new-item? item)
;            (add-item item feed-id)))
;        feed-id))))
;(print (read-feeds))
