(ns feeds.controller
  (:use [clojure.tools.logging]
        [compojure.core]
        [rec-mong.core])
  (:require [noir.session :as sess]
            [noir.response :as resp :only [redirect]]
            [feeds.view :as v]
            [feeds.dal :as dal]
            [feeds.model :as model]
            [feeds.friend :as fh]
            [feeds.management :as mgmt]
            [feeds.util :as util]
            [ring.middleware.nested-params :as np]
            ))

(defn index [req]
  (let [user (fh/user req)] 
    (if user
      (cond
        (fh/user? req) (v/user user)
        (fh/admin? req) (v/admin user)
        true (v/index))
      (v/index))))

(defn login [username login_failed]
  (v/login username login_failed))

(defroutes user-routes
  (GET "/" req (index req))
  )

(defroutes admin-routes
  (GET "/" req (index req))
  mgmt/mgmt-routes
  )

