(ns {{namespace}}.component.redis
  (:require 
   [com.stuartsierra.component :as component]
   [clojure.tools.logging :as log]
   [celtuce.connector :as conn]
   [celtuce.commands :as redis]))

(defn init-conn [component]
  (assoc component :conn (conn/redis-server (-> component :redis-conf :uri))))

(defn init-cmds [component]
  (assoc component :cmds (conn/commands-sync (:conn component))))

(defn stop-conn [component]
  (conn/shutdown (:conn component))
  (-> component
      (dissoc :cmds)
      (dissoc :conn)))

(defrecord RedisComponent [redis-conf]
  component/Lifecycle
  (start [component]
    (if (nil? redis-conf)
      (do
        (log/warn "empty :redis-conf" component)
        component)
      (cond-> component
        (not (:conn component)) (init-conn)
        (not (:cmds component)) (init-cmds))))
  (stop [component]
    (cond-> component
      (:conn component) (stop-conn))))

(defn redis-component [redis-conf]
  (->RedisComponent redis-conf))
