{{=<< >>=}}
(ns dev
  (:refer-clojure :exclude [test])
  (:require
   [clojure.repl :refer :all]
   [clojure.pprint :as pp]
   [clojure.string :as str]
   [clojure.tools.namespace.repl :refer [refresh]]
   [reloaded.repl :refer [system init start stop go reset clear]]
   [eftest.runner :as eftest]
   [com.stuartsierra.component :as component]            
   [io.pedestal.http :as server]
   [crafty.generate :as gen]
   [<<namespace>>.system :as system]))

(defn help []
  (->>
   ["Reloaded repl workflow (using config/dev.edn)"
    "  dev=> (go)"
    "  :started"
    "  dev=> (reset)"
    "  :resumed"
    "  dev=> (stop)"
    "  :stopped"
    ""
    "Create a new component:"
    "  dev=> (gen/component \"baz\")"
    "  Creating file src/foo/component/baz.clj"
    "  Creating file test/foo/component/baz_test.clj"
    "  nil"
    ""
    "Create a new service:"
    "  dev=> (gen/service \"bar\")"
    "  Creating file src/foo/service/bar.clj"
    "  Creating file test/foo/service/bar_test.clj"
    "  nil"
    ""
    "Run all tests (using config/test.edn)"
    "  dev=> (test)"]
   (str/join \newline)
   (println)))

(gen/set-ns-prefix '<<namespace>>)

(defn test []
  (eftest/run-tests 
   (eftest/find-tests "test") 
   {:multithread? false, :report eftest.report.pretty/report}))

(def dev-config
  {:<<name>>-env :dev
   :pedestal
   {:specs {:io.pedestal.http/allowed-origins 
            {:creds true
             :allowed-origins (constantly true)}}
    :interceptors [server/default-interceptors
                   server/dev-interceptors]}})

(defn new-system []
  (system/new-system dev-config))

(reloaded.repl/set-init! new-system)
