(ns {{namespace}}.component.cassandra
  (:require 
   [com.stuartsierra.component :as component]
   [clojure.tools.logging :as log]
   [qbits.alia :as alia]))

(defn init-cluster [component]
  (assoc component :cluster (alia/cluster (:cassa-conf component))))

(defn init-session [component]
  (assoc component :session (alia/connect (:cluster component))))

(defn stop-session [component]
  (alia/shutdown (:session component))
  (dissoc component :session))

(defn stop-cluster [component]
  (alia/shutdown (:cluster component))
  (dissoc component :cluster))

(defrecord CassaComponent [cassa-conf]
  component/Lifecycle
  (start [component]
    (if (nil? cassa-conf)
      (do
        (log/warn "empty :cassa-conf" component)
        component)
      (cond-> component
        (not (:cluster component)) (init-cluster)
        (not (:session component)) (init-session))))
  (stop [component]
    (cond-> component
      (:session component) (stop-session)
      (:cluster component) (stop-cluster))))

(defn cassa-component [cassa-conf]
  (->CassaComponent cassa-conf))
