{{=<< >>=}}
(ns <<namespace>>.system
  (:require
   [com.stuartsierra.component :as component]
   [crafty.component.service :refer [service-component]]
   [crafty.component.pedestal :refer [pedestal-server]]
   [cprop.core :refer [load-config]]
   [cprop.source :refer [from-file from-env]]<<#cassandra?>>
   [<<namespace>>.component.cassandra :refer [cassa-component]]<</cassandra?>><<#example?>>
   [<<namespace>>.service.example :refer [service-example]]<</example?>>))

(defn- merge-configs [conf-base]
  (let [conf-from-env (from-env)
        env (name (or (:<<name>>-env conf-from-env)
                      (:<<name>>-env conf-base)
                      (throw (ex-info "invalid config" 
                                      {:missing #{:<<name>>-env}}))))]
    (load-config :file "config/defaults.edn"
                 :merge [conf-base
                         (from-file (str "config/" env ".edn"))
                         conf-from-env])))

<<#example?>>
(defn- add-swagger-doc [config]
  (assoc-in 
   config
   [:pedestal :swagger :swagger-doc]
   {:swagger "2.0"
    :info {:title "Simple demo"
           :version "0.1.0"
           :description "Crafty API example"}
    :tags [{:name "api" :description "Some apis"}]}))<</example?>>

(defn new-config [conf-base]
  (-> conf-base merge-configs <<#example?>>add-swagger-doc<</example?>>))

(defn new-system [conf-base]
  (let [config (new-config conf-base)]
    (-> (component/system-map
         :http (pedestal-server (:pedestal config))<<#cassandra?>>
         :cassa (cassa-component (:cassandra config))<</cassandra?>><<#example?>>
         :example (service-component service-example)<</example?>>)
        (component/system-using
         {:http [<<#example?>>:example<</example?>>]<<#example?>>
          :example []<</example?>>}))))
