(ns {{namespace}}.service.example-test
  (:require [clojure.test :refer :all]
            [crafty.util.test :refer :all]
            [{{namespace}}.system :as system]
            [clj-http.client :as http]
            [cheshire.core :as json]))

(use-fixtures :once (system-fixture (system/new-system {:env :test})))

(def url (fn-url (system/new-system {:env :test})))

(deftest plus-test
  (testing "plus normal behavior"
    (let [response (http/get (url "/api/plus?x=1&y=2"))]
      (is (= 200 (:status response)))
      (is (= (json/parse-string (:body response) true)
             {:res 3})))))

(deftest pizza-test
  (testing "echo normal behavior"
      (let [pizza (json/generate-string
                   {:name "La Speciale du Chef"
                    :size :L
                    :origin {:country :FR
                             :city "Paris"}})
            response (http/post (url "/api/echo")
                                {:body pizza
                                 :headers {"Content-Type" "application/json"}})]
        (is (= 200 (:status response)))
        (is (= (:body response)
               pizza)))))
