(ns {{namespace}}.main
  (:gen-class)
  (:require [com.stuartsierra.component :as component]
            [io.pedestal.http :as server]
            [crafty.util.runtime :refer [add-shutdown-hook]]
            [{{namespace}}.system :refer [new-system]]))

(def prod-config
  {:env :pro
   :pedestal
   {:interceptors [server/default-interceptors]}})

(defn -main [& args]
  (let [system (new-system prod-config)]
    (println "Starting HTTP server on port"
             (-> system :http :pedestal :specs ::server/port))
    (add-shutdown-hook ::stop-system #(component/stop system))
    (component/start system)))
