(ns {{namespace}}
  (:require [io.pedestal.http.route :refer [expand-routes]]
            [pedestal-api.core :as api]
            [pedestal-api.helpers :as api.h]
            [schema.core :as s]))

(defn h-hello-world [component]
  (api.h/handler
   ::h-hello-world
   {:responses  {200 {:body s/Str}}}
   (fn [request]
     {:status 200
      :body "Hello World"})))

(defn service-{{name}} [component]
  (let [handler-hello-world (h-hello-world component)]
    (s/with-fn-validation
      (expand-routes
       `[[["/" ^:interceptors [(api/negotiate-response)]
           {:get ~handler-hello-world}]]]))))
