(ns specl-slingshot.core
  (:require [speclj.core :refer :all]
            [slingshot.slingshot :refer :all]))

;; Check that an exception was thrown, using a standard catch clause like
;; you would use in a slingshot 'try+'
(defmacro should-throw+ [catch-clause context-binding
                         & [binding-expectations & body]]
  (let [catch-str (str catch-clause)]
    `(try+
       ~@body
       (-fail (str "Did not throw: " ~catch-str))
       (catch ~catch-clause ~context-binding
         ~@binding-expectations))))

;; In the midst of the binding expectations, this function can be called
;; to see if a message was present on the throw
(defmacro should-have-message [msg]
  `(should= ~msg (:message ~'&throw-context)))