# specl-slingshot

A simple utility for writing specs around 
[slingshot](https://github.com/scgilardi/slingshot) exceptions.

## Download

[![Clojars Project](https://img.shields.io/clojars/v/coreagile/specl-slingshot.svg)](https://clojars.org/coreagile/specl-slingshot)

## Documentation

See documentation at <https://specl-slingshot.calmabiding.me/doc/trunk/docs/index.html>

## Sample Usage
```clojure
(ns some-spec
  (:require [slingshot.slingshot :refer :all]
            [specl-slingshot.core :refer :all]
            [speclj.core :refer :all])
  
(defn- throw-thing []
  (throw+ {:type :broken :answer 42} "Something awful"))

(describe "Exception handling"
  (it "should catch exceptions nicely"
    (should-throw+ [:type :broken] {:keys [answer]}
      [(should= 42 answer)
       (should-have-message "Something awful")]
      (throw-thing)))
```

## License

Copyright © 2018 Stephen Starkey

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
