;
; Copyright (c) 2022 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.example.employees
  (:require [itl.core :refer [deftfn parse-date]]))

(def ^:private employee-database
  [{:company-number "4808147"
    :employee-number "9942"
    :first-name "Alice"
    :last-name "Mitchell"
    :hire-date "1981-01-05"}
   {:company-number "4808147"
    :employee-number "1429"
    :first-name "Stephen"
    :last-name "Starkey"
    :hire-date "1974-10-10"}
   {:company-number "5123122"
    :employee-number "8832"
    :first-name "Lisa"
    :last-name "Smith"
    :hire-date "1979-12-15"}])

(deftfn employees-hired {:in [[before parse-date]]}
  (if before
    (filter
      (comp (fn [hire-date] (.isBefore hire-date before)) parse-date :hire-date)
      employee-database)
    employee-database))
