;
; Copyright (c) 2022 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.example.dreams
  (:require [itl.core :refer [deftfn]])
  (:import (java.util UUID)))

(def dreams (atom {}))

(deftfn create-dream [{:keys [id-key]}]
  (let [uuid (str (UUID/randomUUID))]
    (swap! dreams assoc uuid {:friends #{}})
    {:result? "success"
     (keyword id-key) uuid}))

(deftfn add-friend [{:keys [dream-id profile-id]}]
  (let [friends (get-in @dreams [dream-id :friends])]
    {:result? (if (friends profile-id)
                "fail"
                (do (swap! dreams update-in [dream-id :friends] conj profile-id)
                    "success"))}))
