;
; Copyright (c) 2022 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.example.bank
  (:require [itl.core :refer [deftfn ->out parse-double parse-uuid]])
  (:import (java.util UUID)))

;; This is the "business logic"

(defrecord User [username balance id])

(def users (atom {}))

(defn add-user! [username balance]
  (let [id (UUID/randomUUID)]
    (swap! users assoc id (->User username balance id))
    id))

(defn get-user-by-id [id] (get @users id))

(defn update-balance! [id amount]
  (let [balance-path [id :balance], user (get-user-by-id id)]
    (when (and user amount) (swap! users update-in balance-path + amount))))

;; These are the table functions

(deftfn add-user {:in [name [balance parse-double]]}
  {:id? (add-user! name balance)})

(defn- -get-user [id-str] (-> id-str get-user-by-id ->out))

(deftfn get-user {:in [[id parse-uuid]]} (-get-user id))

(deftfn update-balance {:in [[id parse-uuid] [amount parse-double]]}
  (update-balance! id amount)
  (-get-user id))

(comment
  (def user (add-user {:name "Bill" :balance "42"}))
  (def id (:id? user))
  (update-balance {:id id :amount "25.12"})
  (get-user {:id id})
  )
