# itl

Integration Test Library

An experiment in writing executable documentation in Clojure.

Inspired by the
[SLIM Test System](http://fitnesse.org/FitNesse.UserGuide.WritingAcceptanceTests.SliM),
it uses a Markdown parser to transform documents into an AST which can
be executed by regular Clojure functions. Since we are not using classes
and methods, but instead just functions, we couldn't port the SLIM
protocol and write all our tests in FitNesse. This flexibility also
allows us to deviate a bit from the norms enforced by thinking of test
tables as instances of a class.

<a href="https://clojars.org/coreagile/itl" style="background: none">
  <img src="https://img.shields.io/clojars/v/coreagile/itl.svg" alt="itl on Clojars">
</a>

## Project Test Results

This project is self-testing. We run this README file
as part of every build.

* [Markdown Test Results](https://docs.calmabiding.me/itl)

## Prerequisites

I have tested the entire build process using
[JDK 11](https://adoptopenjdk.net/?variant=openjdk11&jvmVariant=hotspot/)

This project's version of Clojure requires at least Java 8.

You'll also need to install [Leiningen](https://leiningen.org/)

## Building the project

The easiest thing to do is run `./prepare-release` to run all the project tests,
document generation, and linting. This is the best way to make sure your changes
work fine.

Other things you can do:

* `lein test` runs the itl tests printing full output
* In a REPL you can run one or all itl tests using `itl.core/run`.
  There is sample code at the bottom of `itl.core`

## Getting

You can download the source code for itl from its
[Project Page](https://git.calmabiding.me/scstarkey/itl)

## Getting Started

Coming soon.

## Testing

This library tests itself! You can run: `lein cli README.md`, which
should execute this document. If you use `lein cli -- -h` you'll see
some options you can use.

!!! abstract "global:itl test suite"
    These are all the different tests for itl itself.

| File      | Result      | Pass | Fail | Exception |
|:----------|:------------|:-----|:-----|:----------|
| tables.md | tables.html | 18   | 0    | 0         |
| tags.md   | tags.html   | 0    | 0    | 0         |
[All ITL Tests (execute-pages: indir=tests, outdir=docs)]

Check out the `itl.example` namespace as well as `bin/test-all` for how
the documentation for this project was executed.

### Making it Pretty

You'll notice this file is pretty nice looking! That's because we
used a nice simple CSS file. The default is in
[resources/itl-md.css](https://git.calmabiding.me/scstarkey/itl/src/branch/master/resources/itl-md.css)
You can specify your own CSS by passing the `--css` flag to `itl.cli`.

### Table Types

See
[source code](https://git.calmabiding.me/scstarkey/itl/src/branch/master/tests/tables.md)
and
[test results](https://docs.calmabiding.me/itl/tables.html)
for more details on which tables you can put into your documents and what they do.

### Tagging

You can tag a section of a document. Then, if you run `itl.cli` with one
or more `-t` or `--tag` switches, followed by the name of the tag you
want to run, only the sections with the given tags, plus the `global`
tag, will be executed. You can see an example of how this is done in
[source code](https://git.calmabiding.me/scstarkey/itl/src/branch/master/tests/tags.md)
and
[test results](https://docs.calmabiding.me/itl/tags.html) for tags.

## Deprecated features

* As of `0.4.0`, Generative tables (`gentable` and `generative-table`)
  are deprecated.
* As of `0.3.3`, AsciiDoc support is deprecated. This means no new features
  will be added to the AsciiDoc portion of the library, and at some future
  release it will be purged altogether.

## Breaking changes

### Upgrading from `0.4.* to 1.*`

1. All deprecated features are no longer present.
2. Page-level operations, bindings, and assertions are no longer
   supported. All work must be done in executable tables now.
3. The approach to working with tables has been rebuilt to be based on
   the SLIM model as closely as possible but in a functional context.
   Read this document closely to see how things have changed. See
   <http://fitnesse.org/FitNesse.UserGuide.WritingAcceptanceTests.SliM>
   to understand the inspiration. We are not using the SLIM protocol,
   but instead operating directly on MarkDown files.

### Upgrading from `0.3.* to 0.4.*`

1. The 4-argument `run` function in `itl.core` has been removed. Use
   one of the other options.
2. The `CSS_FILE` environment variable has been replaced with the
   `--css` switch in `itl.cli` -- you can use `itl.markdown/with-css`
   on the REPL instead of using the environment variable.

### Upgrading from `0.2.* to 0.3.*`

The syntax for `'<x'` variable interpolation has been removed completely.
Use `{{x}}` instead, and don't worry about manually resolving it using
`generated-var`. `column-table` does the resolution for you.

### Upgrading From `0.1.* to 0.2.*`

1. itl used to be quiet. It didn't print any status information. Now it
   does. A lot. If you want it to be quiet again, pass the `--quiet` or `-q`
   switch to `itl.cli`
2. The `execute example files` table used to take an `outdir`, which was where
   it both looked for the example `md` files to parse as well as where it
   writes its file called `example-output.log`. Now, you would use an
   `indir` parameter to specify here `md` files are found, an
   `outdir` parameter to specify where the `html` files are written, and a
   `logfile` parameter for where the output from running the files should go.
   If no `logfile` is given, output will go to standard out. You must specify an
   `indir` and `outdir`

## Contributing

If you have a contribution to make, you are welcome to! Send an email
to <stephen@calmabiding.me> and we can have a conversation about how you
like to contribute!

## License

Copyright © 2019 Stephen Starkey

```
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
```

