(ns itl.example.dreams
  (:require [itl.core :refer [deftfn ->out parse-double parse-uuid]])
  (:import (java.util UUID)))

(def dreams (atom {}))

(deftfn create-dream [{:keys [id-key]}]
  (let [uuid (str (UUID/randomUUID))]
    (swap! dreams assoc uuid {:friends #{}})
    {:result? "success"
     (keyword id-key) uuid}))

(deftfn add-friend [{:keys [dream-id profile-id]}]
  (let [friends (get-in @dreams [dream-id :friends])]
    {:result? (if (friends profile-id)
                "fail"
                (do (swap! dreams update-in [dream-id :friends] conj profile-id)
                    "success"))}))
