;
; Copyright (c) 2022 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.example.milk
  (:require [itl.core :refer [deftfn parse-int]]))

(deftfn buy-milk? {:in [[cash-in-wallet parse-int]
                        [credit-card (fn [s] (= "yes" s))]
                        [units-remaining parse-int]]}
  {:go-to-store? (if (and (= 0 units-remaining)
                          (or (> cash-in-wallet 2) credit-card))
                   "yes" "no")})

;; should be the same as this...
;(deftfn buy-milk? [{:keys [cash-in-wallet credit-card units-remaining]
;                    :as _}]
;  (let [cash-in-wallet (parse-int cash-in-wallet)
;        credit-card ((fn [s] (= "yes" s)) credit-card)
;        units-remaining (parse-int units-remaining)]
;    {:go-to-store? (if (and (= 0 units-remaining)
;                            (or (> cash-in-wallet 2) credit-card))
;                     "yes" "no")}))

(comment
  (buy-milk? {:cash-in-wallet "10", :credit-card "no", :units-remaining "0"})
  ;=> {:go-to-store? "yes"}

  (buy-milk? {:cash-in-wallet "1", :credit-card "no", :units-remaining "0"})
  ;=> {:go-to-store? "no"}
  )