;
; Copyright (c) 2019 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(defproject coreagile/itl "1.0.1"
  :description "Integration Test Library"
  :url "https://docs.calmabiding.me/itl/"
  :license {:name "GNU GPL"
            :url "https://www.gnu.org/licenses/gpl-3.0.en.html"}
  :dependencies [[org.clojure/clojure "1.10.1" :upgrade false]
                 [commons-io "2.6"]
                 [com.climate/claypoole "1.1.4"]
                 [com.vladsch.flexmark/flexmark-all "0.50.44"]
                 [hiccup "1.0.5"]
                 [io.aviso/pretty "0.1.37"]
                 [org.clojure/core.async "0.6.532"]
                 [org.clojure/tools.cli "0.4.2"]
                 [selmer "1.12.18"]]
  :plugins [[lein-ancient "0.6.15"]
            [lein-bikeshed "0.5.2"]
            [lein-kibit "0.1.8"]
            [lein-marginalia "0.9.1"]]
  :javac-options ["-target" "1.8" "-source" "1.8" "-Xlint:-options"]
  :pom-location "target/"
  :pom-addition [:properties
                 [:maven.compiler.source "1.8"]
                 [:maven.compiler.target "1.8"]]
  :aliases {"cli" ["run" "-m" "itl.cli"]
            "itl" ["cli" "README.md" "-o" "docs/index.html"]}
  :source-paths ["src/clojure"])
