;
; Copyright (c) 2019 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(defproject coreagile/itl "0.3.2"
  :description "Integration Test Library"
  :url "https://docs.calmabiding.me/itl/"
  :license {:name "GNU GPL"
            :url "https://www.gnu.org/licenses/gpl-3.0.en.html"}
  :dependencies [[org.clojure/clojure "1.10.1" :upgrade false]
                 [commons-io "2.6"]
                 [com.headius/backport9 "1.3"]
                 [com.vladsch.flexmark/flexmark-all "0.50.20"]
                 [hiccup "1.0.5"]
                 [io.aviso/pretty "0.1.37"]
                 [org.asciidoctor/asciidoctorj "2.1.0"]
                 [org.clojure/tools.cli "0.4.2"]
                 [selmer "1.12.12"]]
  :plugins [[lein-ancient "0.6.15"]
            [lein-bikeshed "0.5.2"]
            [lein-kibit "0.1.7"]
            [lein-marginalia "0.9.1"]]
  :javac-options ["-target" "1.8" "-source" "1.8" "-Xlint:-options"]
  :pom-location "target/"
  :pom-addition [:properties
                 [:maven.compiler.source "1.8"]
                 [:maven.compiler.target "1.8"]]
  :jvm-opts ["--illegal-access=warn"

             ;; for JRuby
             "--add-opens" "java.base/sun.nio.ch=ALL-UNNAMED"
             "--add-opens" "java.base/java.io=ALL-UNNAMED"
             "--add-opens" "java.base/java.lang=ALL-UNNAMED"
             "--add-opens" "java.base/java.lang.reflect=ALL-UNNAMED"
             "--add-opens" "java.base/java.util.regex=ALL-UNNAMED"
             "--add-opens" "java.base/java.net=ALL-UNNAMED"
             "--add-opens" "java.base/java.util=ALL-UNNAMED"
             "--add-opens" "java.base/javax.crypto=ALL-UNNAMED"]
  :aliases {"cli" ["run" "-m" "itl.cli"]
            "itladoc" ["cli" "README.adoc" "-o" "docs/asciidoc.html"]
            "itlmd" ["cli" "README.md" "-o" "docs/index.html"]
            "test" ["itl"]}
  :source-paths ["src/clojure"])
