;
; Copyright (c) 2019 Stephen Starkey.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.print-control
  (:import (java.io PrintWriter ByteArrayOutputStream)))

;;== Allows for one to control when the library should print things to *out*

(def ^:dynamic printing-enabled? true)

(defn attempt [& [f & args]]
  (when printing-enabled?
    (apply f args)
    (flush)))

(defmacro with-printing-enabled [enabled? & body]
  `(binding [printing-enabled? ~enabled?] ~@body))

(defn print-exception [t]
  (let [bytes (ByteArrayOutputStream.)]
    (with-open [my-out (PrintWriter. bytes)]
      (.printStackTrace t my-out))
    (println (String. (.toByteArray bytes)))))