(ns quick-start.core
  (:require [itl.core :refer :all]))

(defn add-nums [n1 n2] (+ n1 n2))

(defop "add two numbers" [{:keys [n1 n2] :as s}]
  (let [n1 (Integer/parseInt n1)
        n2 (Integer/parseInt n2)]
    (assoc s :result (str (add-nums n1 n2)))))

(defn- process-row [{:strs [n1 n2 result]}]
  (let [n1 (Integer/parseInt n1)
        n2 (Integer/parseInt n2)
        expected (Integer/parseInt result)
        actual (add-nums n1 n2)]
    (if (= expected actual)
      {"n1" (str n1)
       "n2" (str n2)
       "result" (pass (str actual))}
      {"n1" (str n1)
       "n2" (str n2)
       "result" (fail (str "Expected " expected " but got " actual))})))

(defn- process-add-table [{:keys [rows]}]
  {:rows (map process-row rows)})

(deftfn "add numbers clunky" [s t]
  [s (process-add-table t)])


(defn- calc-value [{:keys [n1 n2] :as s}]
  (assoc s :result
         (str (add-nums (Integer/parseInt n1)
                        (Integer/parseInt n2)))))

(deftfn "add numbers clean" [s t]
  (column-table s t {:assign {"n1" :n1, "n2" :n2}
                     :exec calc-value
                     :asserts {"result" :result}}))