;
; Copyright (c) 2018.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.example
  (:require [itl.core :refer :all]))

;; # itl example
;;
;; This is where we bind the functions that test itl itself.

;; ## complete-example.adoc fixtures

(defn- calc-balance [{:keys [amount balance] :as s}]
  (let [balance (Integer/parseInt balance)
        to-add (Integer/parseInt amount)
        actual-balance (+ balance to-add)]
    (assoc s :balance (str actual-balance))))

(deftfn "check register" [s t]
  (column-table s t {:assign {"Amount" :amount}
                     :exec calc-balance
                     :asserts {"Balance" :balance}}))

(defn- multiply [{:keys [x y] :as s}]
  (assoc s :result (* x y)))

(deftafn "times tables" [s t {:strs [rows]}]
  (generative-table s t
    {:generate {"X" [:x random-integer]
                "Y" [:y random-integer]}
     :exec multiply
     :asserts {"Result" [:result integer-comparison]}}
    (Integer/parseInt rows)))

(defop "break" [s] (throw (ex-info "This op is broke" {})) s)

(deftfn "broken register" [s t]
  (column-table s t {:assign {"Amount" :amount "Payee" :payee}
                     :exec (fn [{:keys [payee] :as s}]
                             (when (= "tesla" payee)
                               (throw (ex-info "Tesla is overpriced" {})))
                             (calc-balance s))
                     :asserts {"Balance" :balance}}))

(deftfn "broken name list" [s t] (throw (ex-info "No idea what to do here" {})))