;
; Copyright (c) 2018.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(defproject coreagile/itl "0.0.18"
  :description "Integration Test Library"
  :url "https://www.calmabiding.me/projects/itl/"
  :license {:name "GNU GPL"
            :url "https://www.gnu.org/licenses/gpl-3.0.en.html"}
  :dependencies [[org.clojure/clojure "1.9.0" :upgrade false]
                 [commons-io "2.6"]
                 [hiccup "1.0.5"]
                 [io.aviso/pretty "0.1.35"]
                 [org.asciidoctor/asciidoctorj "1.6.0-alpha.7"]
                 [org.clojure/tools.cli "0.4.1"]]
  :plugins [[lein-ancient "0.6.15"]
            [lein-bikeshed "0.5.1"]
            [lein-kibit "0.1.6"]
            [lein-marginalia "0.9.1"]]
  :aliases {"cli" ["run" "-m" "itl.cli"]
            "itl" ["cli" "README.adoc" "-o" "docs/index.html"]}
  :source-paths ["src/clojure"])
