;
; Copyright (c) 2018.
;
; This file is part of itl.
;
; itl is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; itl is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with itl.  If not, see <http://www.gnu.org/licenses/>.
;

(ns itl.render
  (:require [itl.md :as md])
  (:import (com.vladsch.flexmark.html HtmlRenderer)
           (com.vladsch.flexmark.formatter.internal Formatter)))

(defn clean-markdown
  "Take a parsed document and emit a string of cleaned-up Markdown"
  [doc]
  (-> (Formatter/builder md/md-options) (.build) (.render doc)))

(defn md->html
  "Take a parsed document and emit a string of HTML"
  [doc]
  (-> (HtmlRenderer/builder md/md-options) (.build) (.render doc)))