/*
 * Copyright (c) 2018.
 *
 * This file is part of itl.
 *
 * itl is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * itl is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with itl.  If not, see <http://www.gnu.org/licenses/>.
 */

package itl.asciidoc;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.extension.InlineMacroProcessor;

import java.util.Map;

public class OpMacro extends InlineMacroProcessor {
  private static GetOp opGetter;
  private static GetState stateGetter;
  private static SetState setter;

  public OpMacro(String macroName) {
    super(macroName);
  }

  public OpMacro(String macroName, Map<String, Object> config) {
    super(macroName, config);
  }

  @Override
  public Object process(ContentNode parent, String target, Map<String, Object> attributes) {
    //todo https://github.com/asciidoctor/asciidoctorj/issues/653
    String value = String.valueOf(attributes.entrySet().stream().findFirst().get().getValue());

    IFn iFn = opGetter.getOp(value);
    if (null != iFn) {
      setter.replace((IPersistentMap) iFn.invoke(stateGetter.getState()));
      return "<code>" + value + "</code>";
    } else {
      return "<strong>Missing op: '" + value + "'</strong>";
    }
  }

  public static void setOpGetter(GetOp opGetter) {
    OpMacro.opGetter = opGetter;
  }

  public static void setSetter(SetState setter) {
    OpMacro.setter = setter;
  }

  public static void setStateGetter(GetState stateGetter) {
    OpMacro.stateGetter = stateGetter;
  }
}
