/*
 * Copyright (c) 2018.
 *
 * This file is part of itl.
 *
 * itl is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * itl is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with itl.  If not, see <http://www.gnu.org/licenses/>.
 */

package itl;

import com.vladsch.flexmark.ast.ContentNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class AssertionResult extends ContentNode {
  public enum AssertionStatus {
    P {
      @Override
      public <T> T choose(T passValue, T failValue) {
        return passValue;
      }
    }, F;

    public <T> T choose(T passValue, T failValue) {
      return failValue;
    }
  }

  private final AssertionStatus status;
  private final BasedSequence[] segments;
  private final String content;

  AssertionResult(BasedSequence[] segments) {
    super(segments[0]);
    this.segments = new BasedSequence[]{segments[0]};
    this.status = AssertionStatus.valueOf(segments[1].toString());
    this.content = segments[2].toString();
  }

  @Override
  public BasedSequence[] getSegments() {
    return segments;
  }

  AssertionStatus getStatus() {
    return status;
  }

  String getContent() {
    return content;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("AssertionResult{");
    sb.append("status=").append(status);
    sb.append(", content='").append(content).append('\'');
    sb.append('}');
    return sb.toString();
  }
}
