# defenv

<a href="https://clojars.org/coreagile/defenv"><img src="https://img.shields.io/clojars/v/coreagile/defenv.svg" crossorigin="anonymous"></a>

A Clojure library designed to make working with environment variables 
easier.

## Prerequisites

You'll need [Java 8](http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html)
and [Leiningen](https://leiningen.org/).

## Upgrading

Going from `1.0.*` to `2.0.*`

For security purposes, we have made masking of value display the default
behavior. If you want to see the value of a variable, simply add 
`:masked? false` to everything that you don't want to mask.

## Usage

Say you want to define a binding in a namespace that is filled in by
the value specified in an environment variable. Here's the very simplest
way to do it:

```clojure
(require '[defenv.core :refer [defenv]])

(defenv path)
```

Then, if you run `@path` you will see the value of the 
PATH environment variable.

The [project documentation](https://docs.calmabiding.me/defenv/) 
contains much more example usage.

Also, you could try running `DEFENV_TESTING=bob lein usage`

## Questions I imagined you might ask

    Why does `defenv` make delayed bindings?

Well, the project contains a bit of other magic. If you don't make a 
binding to a variable optional, an exception will be thrown when it is
dereferenced if it isn't set. We don't want these exceptions to be 
thrown during compile time. Therefore, they must be delayed.

    Why can't I load property files and declare multiple
    environments in my `project.clj` and stuff?

This library was designed for <https://12factor.net/> apps

## License

Copyright © 2022 Stephen Starkey

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
