;
;     This file is part of defenv.
;
;     defenv is free software: you can redistribute it and/or modify
;     it under the terms of the GNU General Public License as published by
;     the Free Software Foundation, either version 3 of the License, or
;     (at your option) any later version.
;
;     defenv is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;     GNU General Public License for more details.
;
;     You should have received a copy of the GNU General Public License
;     along with defenv.  If not, see <http://www.gnu.org/licenses/>.
;

(defproject coreagile/defenv "1.0.6"
  :description "A library for managing environment variables in Clojure"
  :url "https://git.calmabiding.me/scstarkey/defenv"
  :license {:name "GNU General Public License v3"
            :url "https://www.gnu.org/licenses/gpl.html"}
  :min-lein-version "2.0.0"
  :dependencies [[org.clojure/clojure "1.10.1" :upgrade false]
                 [slingshot "0.12.2"]]
  :javac-options ["-target" "1.8" "-source" "1.8" "-Xlint:-options"]
  :pom-location "target/"
  :pom-addition [:properties
                 [:maven.compiler.source "1.8"]
                 [:maven.compiler.target "1.8"]]
  :profiles {:dev {:dependencies [[com.taoensso/timbre "4.10.0"]
                                  [coreagile/specl-slingshot "0.0.3"]
                                  [hiccup/hiccup "1.0.5"]
                                  [org.clojure/tools.cli "0.4.2"]
                                  [speclj "3.3.2"]]
                   :plugins [[lein-ancient "0.6.15"]
                             [lein-bikeshed "0.5.2"]
                             [lein-dotenv "1.0.0"]
                             [lein-kibit "0.1.7"]
                             [lein-marginalia "0.9.1"]
                             [speclj "3.3.2"]]}}
  :test-paths ["spec"]
  :aliases {"autospec" ["spec" "-a"]
            "usage" ["trampoline" "run" "-m" "defenv.usage"]})
