(ns defenv.docs
  (:require [defenv.core :as env]
            [hiccup.core :as h]))

;; # Documentation Generation

(defn- env-var->html [{:keys [env-name default optional? masked? doc]}]
  [[:dd env-name]
   [:dt
    (when (or default optional? masked?)
      [:ul
       (when default
         [:li {:class "default-value"} "Default: "
          [:span default]])
       (when optional? [:li {:class "optional"} "optional"])
       (when masked? [:li {:class "masked"} "masked"])])
    [:span {:class "doc"} (or doc [:i "No documentation found"])]]])

(defn- env->html [header]
  (h/html
    [:html
     [:head
      [:link {:type "text/css" :href "defenv.css" :rel "stylesheet"}]]
     [:body
      [:h1 header]
      (->> env-var->html
           env/extract-global-spec
           (reduce concat)
           (concat [:dl])
           (into []))]]))

(defn save-html
  "Save the current global environment as an HTML file. The `header` will be
  emitted as an `h1` element at the top of the file. The `file-name` is where
  the contents will be saved."
  [header file-name]
  (spit file-name (env->html header)))

(defn- example-usage []
  (load-file "src/defenv/usage.clj")
  (save-html "defenv environment specification" "test.html"))

(comment
  (example-usage)
  )
