;
;     This file is part of defenv.
;
;     defenv is free software: you can redistribute it and/or modify
;     it under the terms of the GNU General Public License as published by
;     the Free Software Foundation, either version 3 of the License, or
;     (at your option) any later version.
;
;     defenv is distributed in the hope that it will be useful,
;     but WITHOUT ANY WARRANTY; without even the implied warranty of
;     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;     GNU General Public License for more details.
;
;     You should have received a copy of the GNU General Public License
;     along with defenv.  If not, see <http://www.gnu.org/licenses/>.
;

;; # Usage example

(ns defenv.usage
  (:require [clojure.string :as str]
            [defenv.core :as env]
            [slingshot.slingshot :refer [try+]])
  (:gen-class))

;; ## Environment variables

(env/defenv defenv-testing
  "An environment variable with a default value."
  "DEFENV_TESTING"
  :default "A Sensible Default™")

(env/defenv something-missing
  "Shows you what happens when something is missing."
  "DEFENV_MISSING")

(env/defenv some-keyword
  "Shows how values can be converted to keywords."
  "DEFENV_KEYWORD"
  :default "test"
  :tfn keyword)

(env/defenv secret-thing
  "Shows what happens when you mask a var."
  "DEFENV_SECRET"
  :default "oops"
  :masked? true)

(defn -main
  "A very simple example of how to use the library."
  [& _]
  (env/set-usage-print-enabled! true)

  (printf "testing: %s%n" @defenv-testing)
  (try+
    (printf "this should die: %s%n" @something-missing)
    (catch [:type :defenv.core/missing-env] {:keys [missing]}
      (println "Missing:" (str/join ", " missing)))))