(ns compojure.tools.macro)

(def ^:dynamic *req* nil)

(defmacro defhandler0
  [name args & body]
  (if-let [export-fn-name (:export-fn (meta name))]
    `(let [export-fn# (defn ~export-fn-name ~args ~@body)]
       (defn ~name [req#]
         (let [{:keys ~args} (:params req#)]
           (binding [*req* req#]
             (export-fn# ~@args)))))
    `(defn ~name [req#]
       (let [{:keys ~args} (:params req#)]
         (binding [*req* req#]
           ~@body)))))

(defn defhandler
  [&form &env name & fdecl]
  (let [[f-fdecl & fdecl] fdecl
        [m args fdecl] (cond
                        (string? f-fdecl) 	[{:doc f-fdecl} (first fdecl) (rest fdecl)]
                        (map? f-fdecl) 		[f-fdecl (first fdecl) (rest fdecl)]
                        (vector? f-fdecl) 	[{} f-fdecl fdecl]
                        :else				(throw (IllegalArgumentException. (str f-fdecl))))
        [pre fdecl] (if (:pre (first fdecl))
                      [(first fdecl) (rest fdecl)]
                      [nil fdecl])
        m (merge m (meta name))]
    (if pre
      `(defhandler0 ~(with-meta name m)
         ~args
         (cond
          ~@pre
          :else (do ~@fdecl)))
      `(defhandler0 ~(with-meta name m) ~args ~@fdecl))))

(.setMacro #'defhandler)
