(ns com.yolodata.riemann.blypr
  "Forwards events to Blypr."
  (:require [clj-http.client :as client]
            [cheshire.core :as json]))

(def ^:private base-url "http://blypr.com:3000/")

(defn- url [company] (str base-url company))

(defn- status [state]
  (= state "ok"))

(defn- format-blyp [{:keys [host service metric state] :as event}]
  {:prefix (str host)
   :blyps [{:title service
            :type (if metric "numeric" "status")
            :data (or metric state)
            :event event}]})

(defn- post-blyp [{:keys [metric state] :as event} {:keys [company user secret_key send_nil]}]
  (try
    (when (or metric send_nil)
      (client/post (url company)
        {:basic-auth [user secret_key]
         :body (json/generate-string (format-blyp event))
         :socket-timeout 5000
         :conn-timeout 5000
         :content-type :json
         :accept :json}))
    (catch Exception e (comment "Blypr error")))
  )

(defn blypr-out
  "Creates blypr output connector for riemann.
  Takes in a map of parameters,
    required fields: company, user, secret_key,
    optional: send_nil (false)"
  [params]
  (fn [event]
    (post-blyp event params)))
