(ns xapi-schema.schemata.util
                 
                            
                              
                                            
                                                  
         (:require
          [schema.core :as s :include-macros true]
          [schema.utils :as su]
          [cljs.core.match :refer-macros [match]]
          [clojure.walk :refer [prewalk postwalk]]))

(defn check-type
  "make a predicate to check for a given object type"
  [type-string]
  (fn [data]
    (= type-string (or (get data "objectType") (get data :objectType)))))

(defn object-type-dispatch
  [& types-and-schemas]
  "returns a conditional schema for the given map of objectTypes"

  (apply s/conditional (flatten (map (fn [[obj-type schema]]
                                       (if (= :else obj-type)
                                         [:else schema]
                                         [(check-type obj-type) schema]))
                                     (partition 2 types-and-schemas)))))

(defn- value-error [e]
  (match [e]
         [([(what :guard string?) value] :seq)] (str what ": " value)
         [(['sequential? value] :seq)] (str "sequential: " value)
         [(['map? value] :seq)] (str "map: " value)
         [(['integer? value] :seq)] (str "an integer: " value)

         ;; catch cljs string schema, as it is just string?
               
         [([(what :guard (partial = string?)) value] :seq)]
               
         (str "a string: " value)

         [(['instance? klass value] :seq)]
         (str (cond
                                                
                                  

                                                
                       (= klass s/Num)
                "a number: "
                                                 
                       (= klass s/Bool)
                "a boolean: "
                :else
                (throw
                 (                        js/Error.
                       (str "Couldn't parse instance? predicate:" e))))
              value)
         [(['= what value]:seq)]
         (str what ": " value)

         [([(in :guard set?) value] :seq)]
         (str "in " in ": " value)
         :else (throw
                (                        js/Error.
                       (str "Couldn't parse validation error: " e)))))

(defn error->string [e]
  (match [e]
         ['missing-required-key] "Missing"
         ['disallowed-key] "Not Allowed"
         [(['not what] :seq)] (str "Not " (value-error what))
         [(['throws? what]:seq)] (str "Not " (value-error what) " (threw)")
         :else e))

(defn named-error? [object]
  (instance? schema.utils.NamedError object))

(defn validation-error? [object]
  (instance? schema.utils.ValidationError object))


(defn- error->data [node]
  (cond
    (named-error? node)
    (let [name                           (.-name node)
          error                            (.-error node)]
      (error->data error))
    (validation-error? node)
    (su/validation-error-explain node)
          :else node))

(defn errors->data [e]
  (postwalk
   (fn [node]
     (error->string node))
   (prewalk
    error->data
    e)))

;;;;;;;;;;;; This file autogenerated from src/cljx/xapi_schema/schemata/util.cljx
