(ns xapi-schema.core
  (:require
   [xapi-schema.schemata.json :refer [Statement Statements]]
        
                      
                              
          [schema.core :as s
           :include-macros true]
   [schema.utils :as su]
   [xapi-schema.schemata.util :as u]))

(def statement-checker
  (s/checker Statement))

(def statements-checker
  (s/checker Statements))

(def errors->data
  u/errors->data)

(defn validate-statement [s]
  (if-let [error (statement-checker s)]
                                          
           (throw (js/Error. (str error)))
    s))

(defn validate-statements [ss]
  (if-let [error (statements-checker ss)]
                                          
           (throw (js/Error. (str error)))
    ss))

(defn validate-statement-data* [sd]
  (if (map? sd)
    (validate-statement sd)
    (validate-statements sd)))

(defn validate-statement-data [sd]
       
                                 
                                                              
                                        
        
  (validate-statement-data*
   (cond
     (string? sd) (.parse js/JSON sd)
     :else sd)))

      
(defn ^:export validate-statement-data-js
  [sd]
  (clj->js (validate-statement-data (js->clj sd))))

;;;;;;;;;;;; This file autogenerated from src/cljx/xapi_schema/core.cljx
