(ns xapi-schema.core
  (:require
   [xapi-schema.schemata.json :refer [Statement Statements]]
        
   [schema.core :as s]
         [cheshire.core :as c]
                            
                                          ))

(def statement-checker
  (s/checker Statement))

(def statements-checker
  (s/checker Statements))

(defn validate-statement [s]
  (if-let [error (statement-checker s)]
          (throw (Exception. (str error)))
                                          
    s))

(defn validate-statements [ss]
  (if-let [error (statements-checker ss)]
          (throw (Exception. (str error)))
                                          
    ss))

(defn validate-statement-data* [sd]
  (if (map? sd)
    (validate-statement sd)
    (validate-statements sd)))

(defn validate-statement-data [sd]
       
  (validate-statement-data* (cond
                              (string? sd) (c/parse-string sd)
                              :else sd))
        
                           
        
                                     
               )

      
                                         
      
                                                   

;;;;;;;;;;;; This file autogenerated from src/cljx/xapi_schema/core.cljx
