(ns com.yetanalytics.lrs.pedestal.routes.activities
  (:require [com.yetanalytics.lrs :as lrs]
            [com.yetanalytics.lrs.protocol :as p]
            [clojure.core.async :as a :include-macros true]
            [com.yetanalytics.lrs.auth :as auth]
            [clojure.spec.alpha :as s :include-macros true]))

(s/fdef get-response
  :args (s/cat :ctx map?
               :get-about-ret ::p/get-activity-ret))

(defn get-response
  [ctx {:keys [error activity] ?etag :etag :as _activity-response}]
  (if error
    (assoc ctx :io.pedestal.interceptor.chain/error error)
    (let [activity-id (-> ctx
                          :xapi
                          :xapi.activities.GET.request/params
                          :activityId)
          version     (:com.yetanalytics.lrs/version ctx)]
      (assoc ctx
             :response
             (case version
               "1.0.3"
               (if activity
                 (cond-> {:status 200
                          :body activity}
                   ?etag (assoc :com.yetanalytics.lrs.pedestal.interceptor/etag
                                ?etag))
                 {:status 404})
               "2.0.0"
               (cond-> {:status 200
                        :body (or activity
                                  {"id" activity-id
                                   "objectType" "Activity"})}
                 ?etag (assoc :com.yetanalytics.lrs.pedestal.interceptor/etag
                              ?etag)))))))

(def handle-get
  {:name ::handle-get
   :enter
   (fn handle-get-fn
     [{auth-identity ::auth/identity
       :keys [xapi com.yetanalytics/lrs] :as ctx}]
     (let [{params :xapi.activities.GET.request/params} xapi]
       (if (p/activity-info-resource-async? lrs)
         (a/go
           (get-response ctx (a/<!
                              (lrs/get-activity-async lrs
                                                      ctx
                                                      auth-identity
                                                      params))))
         (get-response ctx (lrs/get-activity lrs ctx auth-identity params)))))})
