(ns com.yetanalytics.jwtini
  (:require [cljs.nodejs :as node]
            fs
            [jsonwebtoken :as jwt]))

(defn sign
  "Sign a json (as clojure data) payload with:
     * secret & HMAC SHA256
     * secret + options
     * secret + options + callback (async)"
  ([payload secret]
   (sign payload secret {:algorithm "HS256"}))
  ([payload secret options]
   (sign payload
         secret
         (merge {:algorithm "RS256"}
                options)
         nil))
  ([payload secret options callback]
   (try
     (if callback
       (.sign jwt
              (clj->js payload)
              secret
              (clj->js
               (merge {:algorithm "RS256"}
                      options)
               callback))
       (.sign jwt
              (clj->js payload)
              secret
              (clj->js
               (merge {:algorithm "RS256"}
                      options))))

     (catch js/Error e
       (throw (ex-info (.-message e)
                       {:type (keyword "com.yetanalytics.jwtini"
                                       (.-name e))} e))))))

(defn verify
  "Verify & Decode a JWT with:
     * secret
     * secret + options
     * secret + options + callback (async)"
  ([token secret]
   (verify token secret {:algorithms ["RS256" "HS256"]}))
  ([token secret options]
   (verify token
           secret
           options
           nil))
  ([token secret options callback]
   (try
     (js->clj
      (if callback
        (.verify jwt
                 token
                 secret
                 options
                 callback)
        (.verify jwt
                 token
                 secret
                 options
                 )) :keywordize-keys true)

     (catch js/Error e
       (throw (ex-info (.-message e)
                       {:type (keyword "com.yetanalytics.jwtini"
                                       (.-name e))} e))))))
