(ns com.yetanalytics.gen-openapi.splice
  (:require
   [clojure.spec.alpha :as sp]
   [com.yetanalytics.gen-openapi.generate :as g]
   [com.yetanalytics.gen-openapi.generate.params :as p]
   [clojure.string]))

(defn annotate-unchanged [route data]
  (vary-meta route assoc :openapi data))

(defn generate-default-operation-id [path method]
  (as-> path p-path
    (clojure.string/replace p-path #"[:\*]" "")
    (if (= \/ (last p-path))
      (apply str (drop-last p-path))
      p-path)
    (if (= \/ (first p-path))
      (apply str (drop 1 p-path))
      p-path)
    (clojure.string/replace p-path \/ \-)
    (str (name method) \- p-path)
    (keyword p-path)))

(defn add-op-id [annotation])

(generate-default-operation-id "/users/:user-id/profile/*subpage/" :get)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(sp/def ::openapi string?)
(sp/def ::title string?)
(sp/def ::version string?)
(sp/def ::info (sp/keys :req-un [::title ::version]))

(sp/def ::openapi-spec (sp/keys :req-un [::openapi
                                         ::info]))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn- extract-annotation [route]
  (-> route meta :openapi))

(defn add-default-operation-id [annot]
  (let [path (key (first annot))
        method (key (first (annot path)))
        m (get-in annot path method)]
    (if (or (get-in annot [path method :operationId])
            (get-in annot [path method "operationId"]))
      annot
      (assoc-in annot [path method :operationId]
                (generate-default-operation-id path method)))))

(defn process-annotation [annot]
  (-> annot
      (p/process-params)
      add-default-operation-id))

(defn compare-vec-path [a b]
  (compare (first (keys a))
           (first (keys b))))

(defn process-routes [set-of-route-vecs]
  (->> set-of-route-vecs
       (reduce (fn [acc v]
                 (merge-with merge acc
                             (-> v
                                 extract-annotation
                                 process-annotation)))
               (sorted-map-by compare-vec-path))))

(defn final-process [rest-of-map set-of-route-vecs]
  (->> set-of-route-vecs
      process-routes
      (assoc rest-of-map :paths)))
