(ns com.yetanalytics.gen-openapi.core
  (:require [com.yetanalytics.gen-openapi.generate :as g]
            [com.yetanalytics.gen-openapi.generate.schema :as gs]
            [com.yetanalytics.gen-openapi.splice :as splice]
            [clojure.spec.alpha :as sp]
            [spec-tools.json-schema :as json-schema]
            [xapi-schema.spec.resources :as r]
            #?(:clj [cheshire.core])))

(defn to-json [x]
  #?(:clj (cheshire.core/generate-string x)
     :cljs (.stringify js/JSON (clj->js x))))

(defn make-oa-map [generals route-vecs]
  (->> route-vecs
       splice/process-routes
       (assoc generals :paths)))

(defn annotate [route data]
  (let [[route data] (if (vector? route)
                       [route data]
                       [data route])
        [path method] route]
    (splice/annotate-unchanged route {path {method data}})))

(def o gs/o)
(def a gs/a)
(def dsl gs/dsl)
(def request g/request)
(def response g/response)
