(ns com.yetanalytics.gen-openapi.splice
  (:require
   [clojure.spec.alpha :as sp]
   [com.yetanalytics.gen-openapi.generate :as g]
   [com.yetanalytics.gen-openapi.generate.params :as p]
   [cheshire.core :as json]))

(defn annotate-unchanged [route data]
  (vary-meta route assoc :openapi data))

(defn generate-default-operation-id [[path method :as route]]
  (as-> path p-path
    (clojure.string/replace p-path #"[:\*]" "")
    (if (= \/ (last p-path))
      (apply str (drop-last p-path))
      p-path)
    (if (= \/ (first p-path))
      (apply str (drop 1 p-path))
      p-path)
    (clojure.string/replace p-path \/ \-)
    (str (name method) \- p-path)
    (keyword p-path)))

(generate-default-operation-id ["/users/:user-id/profile/*subpage/" :get])


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(sp/def ::openapi string?)
(sp/def ::title string?)
(sp/def ::version string?)
(sp/def ::info (sp/keys :req-un [::title ::version]))

(sp/def ::openapi-spec (sp/keys :req-un [::openapi
                                         ::info]))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defn- extract-annotation [route]
  (-> route meta :openapi))

(defn process-annotation [annot]
  (-> annot
      (p/process-params)))

(defn process-routes [set-of-route-vecs]
  (->>  set-of-route-vecs
        (reduce (fn [acc v]
                  (merge-with merge acc
                              (-> v
                                  extract-annotation
                                  process-annotation))) {})))

(defn final-process [rest-of-map set-of-route-vecs]
  (->> set-of-route-vecs
      process-routes
      (assoc rest-of-map :paths)))
